import cv2
import easyocr
import re

image_path = r"C:/Users/Hossein/.gemini/antigravity/brain/6db23134-4202-4417-adc4-6d56a82f6983/uploaded_image_1766909449714.jpg"

print("Loading...")
image = cv2.imread(image_path)

# Resize
target_width = 1000
h, w = image.shape[:2]
scale = target_width / w
target_height = int(h * scale)
image = cv2.resize(image, (target_width, target_height))

# Extract Blue Box ROI (where ID is)
id_y1 = int(target_height * 0.03)
id_y2 = int(target_height * 0.23)
id_x1 = int(target_width * 0.50)
id_x2 = int(target_width * 0.95)

header_roi = image[id_y1:id_y2, id_x1:id_x2]
cv2.imwrite("test_header_roi.jpg", header_roi)

# Upscale
scale_factor = 3
width = int(header_roi.shape[1] * scale_factor)
height = int(header_roi.shape[0] * scale_factor)
enlarged = cv2.resize(header_roi, (width, height), interpolation=cv2.INTER_CUBIC)

gray = cv2.cvtColor(enlarged, cv2.COLOR_BGR2GRAY)

# Try different thresholds
print("\n=== Testing different thresholds ===\n")

# 1. Otsu
_, otsu = cv2.threshold(gray, 0, 255, cv2.THRESH_BINARY + cv2.THRESH_OTSU)
cv2.imwrite("test_otsu.jpg", otsu)

# 2. Inverted Otsu
_, inv_otsu = cv2.threshold(gray, 0, 255, cv2.THRESH_BINARY_INV + cv2.THRESH_OTSU)
cv2.imwrite("test_inv_otsu.jpg", inv_otsu)

# 3. Simple threshold
_, simple = cv2.threshold(gray, 127, 255, cv2.THRESH_BINARY)
cv2.imwrite("test_simple.jpg", simple)

print("Initializing EasyOCR...")
reader = easyocr.Reader(['fa', 'en'], gpu=False)

images_to_test = [
    ("Original Gray", gray),
    ("Otsu Threshold", otsu),
    ("Inverted Otsu", inv_otsu),
    ("Simple Threshold", simple)
]

for name, img in images_to_test:
    print(f"\n--- {name} ---")
    
    # Test 1: NO allowlist (see what it reads)
    print("Without allowlist:")
    results = reader.readtext(img)
    for (bbox, text, prob) in results:
        if prob > 0.1:
            print(f"  '{text}' | {prob:.2f}")
    
    # Test 2: With allowlist (Persian + English digits)
    print("With digits allowlist:")
    results = reader.readtext(img, allowlist='0123456789۰۱۲۳۴۵۶۷۸۹')
    for (bbox, text, prob) in results:
        if prob > 0.05:
            print(f"  '{text}' | {prob:.2f}")
            # Normalize
            normalized = text
            for persian, english in zip('۰۱۲۳۴۵۶۷۸۹', '0123456789'):
                normalized = normalized.replace(persian, english)
            if len(normalized) >= 10:
                print(f"    -> {normalized}")

print("\n\nCheck these files to see what's happening:")
print("  - test_header_roi.jpg (the ROI)")
print("  - test_otsu.jpg")
print("  - test_inv_otsu.jpg")
print("  - test_simple.jpg")
