import cv2
import pytesseract
import re

# Test image
image_path = r"C:/Users/Hossein/.gemini/antigravity/brain/6db23134-4202-4417-adc4-6d56a82f6983/uploaded_image_1766909449714.jpg"

print("Loading image...")
image = cv2.imread(image_path)

# Resize
target_width = 1000
h, w = image.shape[:2]
scale = target_width / w
target_height = int(h * scale)
image = cv2.resize(image, (target_width, target_height))

# Extract header (Top-Right quadrant)
header_h = int(target_height * 0.25)
header_x_start = int(target_width * 0.4)
header_roi = image[0:header_h, header_x_start:]

# Upscale
scale_factor = 3
width = int(header_roi.shape[1] * scale_factor)
height = int(header_roi.shape[0] * scale_factor)
enlarged = cv2.resize(header_roi, (width, height), interpolation=cv2.INTER_CUBIC)

gray = cv2.cvtColor(enlarged, cv2.COLOR_BGR2GRAY)
_, thresh = cv2.threshold(gray, 0, 255, cv2.THRESH_BINARY + cv2.THRESH_OTSU)

cv2.imwrite("test_thresh.jpg", thresh)
print("Saved test_thresh.jpg")

# Pytesseract with Persian
print("\nTesting with Pytesseract (Persian)...")
custom_config = r'--oem 3 --psm 6 -c tessedit_char_whitelist=۰۱۲۳۴۵۶۷۸۹0123456789'

text = pytesseract.image_to_string(thresh, lang='fas', config=custom_config)
print(f"Raw text:\n{text}\n")

# Normalize Persian to English
replacements = {
    '۰': '0', '۱': '1', '۲': '2', '۳': '3', '۴': '4',
    '۵': '5', '۶': '6', '۷': '7', '۸': '8', '۹': '9',
}
normalized = text
for k, v in replacements.items():
    normalized = normalized.replace(k, v)

print(f"Normalized:\n{normalized}\n")

# Extract only digits
digits_only = re.sub(r'\D', '', normalized)
print(f"Digits only: {digits_only}")

# Find 10-digit sequences
if len(digits_only) >= 10:
    for i in range(len(digits_only) - 9):
        candidate = digits_only[i:i+10]
        print(f"10-digit candidate: {candidate}")
        
        # Validate Iranian National ID
        try:
            check = int(candidate[9])
            s = sum(int(candidate[x]) * (10 - x) for x in range(9))
            remainder = s % 11
            is_valid = (remainder < 2 and check == remainder) or (remainder >= 2 and check + remainder == 11)
            print(f"  Valid: {is_valid}")
        except:
            print(f"  Valid: False (error)")
