"""
Test to verify bubble ordering in Persian OMR

In Persian OMR (RTL), the layout is:
[Question Box] 1 2 3 4 5

From left to right on screen, we see:
5 4 3 2 1 [Box]

So if we sort by X ascending (left to right):
Position 0 = 5
Position 1 = 4
Position 2 = 3
Position 3 = 2
Position 4 = 1
Position 5 = Box

We need to:
1. Remove box (position 5)
2. Map remaining: 0->5, 1->4, 2->3, 3->2, 4->1
"""

# Simulate a row with X coordinates
# Left side (small X) to Right side (large X)
bubbles = [
    (100, 50, 10, 150, "Bubble for option 5"),
    (150, 50, 10, 140, "Bubble for option 4"),  
    (200, 50, 10, 80, "Bubble for option 3 - FILLED"),  # This one is filled (darkest)
    (250, 50, 10, 160, "Bubble for option 2"),
    (300, 50, 10, 155, "Bubble for option 1"),
    (350, 50, 10, 170, "Question number box"),
]

print("Original bubbles (as detected):")
for i, (x, y, r, intensity, label) in enumerate(bubbles):
    print(f"  {i}: X={x}, Intensity={intensity}, {label}")

# Step 1: Sort by X (left to right)
bubbles.sort(key=lambda b: b[0])
print("\nAfter sorting by X (ascending):")
for i, (x, y, r, intensity, label) in enumerate(bubbles):
    print(f"  {i}: X={x}, Intensity={intensity}, {label}")

# Step 2: Remove rightmost (question box)
removed = bubbles.pop()
print(f"\nRemoved: {removed[4]}")

# Step 3: Current code reverses
bubbles_reversed = list(reversed(bubbles))
print("\nAfter reverse:")
for i, (x, y, r, intensity, label) in enumerate(bubbles_reversed):
    option_num = i + 1
    print(f"  Option {option_num}: X={x}, Intensity={intensity}, {label}")

# Find filled (minimum intensity)
min_intensity = min(b[3] for b in bubbles_reversed)
filled_idx = [i for i, b in enumerate(bubbles_reversed) if b[3] == min_intensity][0]
filled_option = filled_idx + 1

print(f"\n✓ Filled option detected: {filled_option}")
print(f"  Expected: 3")
print(f"  Match: {filled_option == 3}")

# What if we DON'T reverse?
print("\n" + "="*50)
print("What if we DON'T reverse?")
print("="*50)

bubbles2 = [
    (100, 50, 10, 150, "Bubble for option 5"),
    (150, 50, 10, 140, "Bubble for option 4"),  
    (200, 50, 10, 80, "Bubble for option 3 - FILLED"),
    (250, 50, 10, 160, "Bubble for option 2"),
    (300, 50, 10, 155, "Bubble for option 1"),
    (350, 50, 10, 170, "Question number box"),
]

bubbles2.sort(key=lambda b: b[0])
bubbles2.pop()  # Remove box

# Map positions to options
# Position 0 (X=100) should be option 5
# Position 4 (X=300) should be option 1
for i, (x, y, r, intensity, label) in enumerate(bubbles2):
    # Position mapping: i -> (5 - i)
    option_num = 5 - i
    print(f"  Option {option_num}: X={x}, Intensity={intensity}, {label}")

min_intensity = min(b[3] for b in bubbles2)
filled_idx = [i for i, b in enumerate(bubbles2) if b[3] == min_intensity][0]
filled_option_v2 = 5 - filled_idx

print(f"\n✓ Filled option (formula 5-i): {filled_option_v2}")
print(f"  Expected: 3")
print(f"  Match: {filled_option_v2 == 3}")
