def validate_iranian_national_id(national_id):
    """Validate Iranian National ID checksum."""
    if not national_id or len(national_id) != 10:
        return False
    
    try:
        check = int(national_id[9])
        s = sum(int(national_id[x]) * (10 - x) for x in range(9))
        remainder = s % 11
        
        if remainder < 2:
            return check == remainder
        else:
            return check + remainder == 11
    except:
        return False

# Test the candidates
candidates = [
    "1368591288",  # What OCR read
    "1368091288",  # Real ID
    "1368591213",  # What fix produced
]

for cand in candidates:
    valid = validate_iranian_national_id(cand)
    print(f"{cand}: {'✓ VALID' if valid else '✗ INVALID'}")

# Check if fix logic would work
import itertools

def try_fix(candidate):
    chars = list(candidate)
    possibilities = []
    
    for char in chars:
        options = [char]
        if char == '8': options.extend(['1', '3'])
        if char == '1': options.append('8')  
        if char == '5': options.append('0')
        if char == '0': options.append('5')
        if char == '3': options.append('8')
        if char == '6': options.append('9')
        if char == '9': options.append('6')
        possibilities.append(options)
    
    print(f"\nTrying to fix: {candidate}")
    print(f"Possibilities per position: {[len(p) for p in possibilities]}")
    
    count = 0
    for p in itertools.product(*possibilities):
        attempt = "".join(p)
        if attempt != candidate and validate_iranian_national_id(attempt):
            print(f"  Found valid: {attempt}")
            return attempt
        count += 1
    
    print(f"  Tried {count} combinations, no valid ID found")
    return None

result = try_fix("1368591288")
print(f"\nFix result: {result}")
