import cv2
import easyocr
import re

# Load image
image_path = r"C:/Users/Hossein/.gemini/antigravity/brain/6db23134-4202-4417-adc4-6d56a82f6983/uploaded_image_1766909449714.jpg"

print("Loading image...")
image = cv2.imread(image_path)

# Resize
target_width = 1000
h, w = image.shape[:2]
scale = target_width / w
target_height = int(h * scale)
image = cv2.resize(image, (target_width, target_height))

print(f"Image size: {image.shape}")

# Save full image
cv2.imwrite("test_full_resized.jpg", image)

# Initialize EasyOCR
print("\nInitializing EasyOCR...")
reader = easyocr.Reader(['fa', 'en'], gpu=False)

# Read ENTIRE image
print("\nReading ENTIRE image...")
results = reader.readtext(image)

print(f"\n=== ALL TEXT FOUND IN ENTIRE IMAGE ===\n")
for i, (bbox, text, prob) in enumerate(results):
    print(f"{i+1}. Text: '{text}'")
    print(f"   Confidence: {prob:.2f}")
    print(f"   Position: {bbox[0]}")  # Top-left corner
    
    # Check if it contains digits
    normalized = text
    for persian, english in zip('۰۱۲۳۴۵۶۷۸۹', '0123456789'):
        normalized = normalized.replace(persian, english)
    
    digits = re.sub(r'\D', '', normalized)
    if digits:
        print(f"   Contains digits: {digits}")
        if len(digits) >= 10:
            print(f"   ★★★ HAS 10+ DIGITS!")
    print()

print("\n" + "="*50)
print("Look for the text that contains the National ID")
print("Expected: ۱۳۶۸۰۴۶۳۶۳ (Persian digits)")
print("="*50)
