from omr_logic import OmrEngine

# Test the fix algorithm
engine = OmrEngine()

# Simulate OCR errors:
# Correct: 1367937401
# OCR reads: 8367937451 (1→8 at pos 0, 0→5 at pos 8)

print("Testing National ID Fix Algorithm")
print("="*60)

# Test case 1: Both errors
wrong_id = "8367937451"
print(f"\nInput (wrong):  {wrong_id}")
print(f"Expected fix:   1367937401")
fixed = engine.try_fix_candidate(wrong_id)
print(f"Actual fix:     {fixed}")
if fixed == "1367937401":
    print("✓ SUCCESS")
else:
    print("✗ FAILED")

# Test case 2: Only first error (1→8)
wrong_id2 = "8367937401"
print(f"\n\nInput (wrong):  {wrong_id2}")
print(f"Expected fix:   1367937401")
fixed2 = engine.try_fix_candidate(wrong_id2)
print(f"Actual fix:     {fixed2}")
if fixed2 == "1367937401":
    print("✓ SUCCESS")
else:
    print("✗ FAILED")

# Test case 3: Only second error (0→5)
wrong_id3 = "1367937451"
print(f"\n\nInput (wrong):  {wrong_id3}")
print(f"Expected fix:   1367937401")
fixed3 = engine.try_fix_candidate(wrong_id3)
print(f"Actual fix:     {fixed3}")
if fixed3 == "1367937401":
    print("✓ SUCCESS")
else:
    print("✗ FAILED")

# Test case 4: Verify the correct ID validates properly
print(f"\n\nValidating correct ID: 1367937401")
is_valid = engine.validate_iranian_national_id("1367937401")
print(f"Valid: {is_valid}")
if is_valid:
    print("✓ SUCCESS")
else:
    print("✗ FAILED - The correct ID doesn't pass validation!")
