# omr-engine/test_local.py
import cv2
import os
import easyocr
from omr_logic import OmrEngine

# 1. تنظیم فایل عکس تست
# (نام یکی از عکس‌های آپلود شده را اینجا بگذارید یا عکسی به نام test.jpg کنار این فایل کپی کنید)
IMAGE_PATH = "temp_uploads/unnamed.jpg"  # <-- مسیر عکس خودتان را چک کنید

if not os.path.exists(IMAGE_PATH):
    print(f"❌ Error: Image not found at {IMAGE_PATH}")
    # سعی می‌کنیم اولین عکس jpg موجود در پوشه را پیدا کنیم
    import cv2
from omr_logic import OmrEngine
import easyocr
import os

# Init
print("Init EasyOCR...")
reader = easyocr.Reader(['fa', 'en'], gpu=True) # or False
engine = OmrEngine(reader)

# Image Path (From User Metadata)
# Image Path (From User Metadata)
image_path = r"C:/Users/Hossein/.gemini/antigravity/brain/6db23134-4202-4417-adc4-6d56a82f6983/uploaded_image_1766909449714.jpg"

print(f"Processing: {image_path}")

try:
    if not os.path.exists(image_path):
        print(f"File not found: {image_path}")
        exit(1)

    result = engine.process_exam(image_path, options_count=5)
    
    print("\n--- RESULT ---")
    print(f"Status: {result.get('status')}")
    print(f"ID: {result.get('national_id')}")
    print("Answers:")
    answers = result.get('answers', {})
    # Sort by Q Num
    for q in sorted(answers.keys()):
        print(f"Q{q}: {answers[q]}")

except Exception as e:
    print(f"Error: {e}")
print("-" * 30)