import cv2
import easyocr
import re

# Test the uploaded image
image_path = r"C:/Users/Hossein/.gemini/antigravity/brain/6db23134-4202-4417-adc4-6d56a82f6983/uploaded_image_1766909449714.jpg"

print("Loading image...")
image = cv2.imread(image_path)
if image is None:
    print("ERROR: Image not found!")
    exit(1)

# Resize to standard width
target_width = 1000
h, w = image.shape[:2]
scale = target_width / w
target_height = int(h * scale)
image = cv2.resize(image, (target_width, target_height))

# Extract header (Top-Right quadrant)
header_h = int(target_height * 0.25)
header_x_start = int(target_width * 0.4)
header_roi = image[0:header_h, header_x_start:]

# Save the ROI for inspection
cv2.imwrite("debug_header_roi.jpg", header_roi)
print(f"Saved header ROI to debug_header_roi.jpg (size: {header_roi.shape})")

# Upscale
scale_factor = 2
width = int(header_roi.shape[1] * scale_factor)
height = int(header_roi.shape[0] * scale_factor)
enlarged = cv2.resize(header_roi, (width, height), interpolation=cv2.INTER_LINEAR)

gray = cv2.cvtColor(enlarged, cv2.COLOR_BGR2GRAY)
_, thresh = cv2.threshold(gray, 0, 255, cv2.THRESH_BINARY + cv2.THRESH_OTSU)

cv2.imwrite("debug_thresh.jpg", thresh)
print("Saved thresholded image to debug_thresh.jpg")

# Initialize EasyOCR
print("Initializing EasyOCR with Farsi...")
reader = easyocr.Reader(['fa', 'en'], gpu=False)

# Run OCR
print("Running OCR...")
results = reader.readtext(thresh, allowlist='0123456789۰۱۲۳۴۵۶۷۸۹')

print("\n--- OCR RESULTS ---")
for (bbox, text, prob) in results:
    print(f"Text: '{text}' | Confidence: {prob:.2f}")
    
    # Normalize Persian to English
    replacements = {
        '۰': '0', '۱': '1', '۲': '2', '۳': '3', '۴': '4',
        '۵': '5', '۶': '6', '۷': '7', '۸': '8', '۹': '9',
    }
    normalized = text
    for k, v in replacements.items():
        normalized = normalized.replace(k, v)
    
    print(f"Normalized: '{normalized}'")
    
    # Look for 10 digits
    matches = re.findall(r'\d{10,}', normalized)
    if matches:
        print(f"Found 10-digit candidates: {matches}")

print("\n--- END ---")
