def validate_iranian_national_id(national_id):
    """Validate Iranian National ID checksum."""
    if not national_id or len(national_id) != 10:
        return False
    
    try:
        check = int(national_id[9])
        s = sum(int(national_id[x]) * (10 - x) for x in range(9))
        remainder = s % 11
        
        if remainder < 2:
            return check == remainder
        else:
            return check + remainder == 11
    except:
        return False

# کدملی که روی برگه نوشته شده
written_id = "1368591288"

print(f"کدملی روی برگه: {written_id}")
print(f"معتبر: {validate_iranian_national_id(written_id)}")

# محاسبه checksum
check = int(written_id[9])
s = sum(int(written_id[x]) * (10 - x) for x in range(9))
remainder = s % 11

print(f"\nChecksum calculation:")
print(f"  Sum of weighted digits: {s}")
print(f"  Remainder (% 11): {remainder}")
print(f"  Check digit in ID: {check}")

if remainder < 2:
    print(f"  Expected check digit: {remainder}")
    print(f"  ✗ Mismatch! Should be {remainder} but is {check}")
else:
    expected = 11 - remainder
    print(f"  Expected check digit: {expected}")
    print(f"  {'✓ Match!' if check == expected else f'✗ Mismatch! Should be {expected} but is {check}'}")

# پیدا کردن رقمی که اگه عوض بشه، checksum درست میشه
print(f"\nTrying to find which digit could be wrong:")

for pos in range(10):
    for new_digit in '0123456789':
        if new_digit == written_id[pos]:
            continue
        
        test_id = written_id[:pos] + new_digit + written_id[pos+1:]
        
        if validate_iranian_national_id(test_id):
            print(f"  Position {pos}: Change '{written_id[pos]}' → '{new_digit}' = {test_id} ✓")

print(f"\n{'='*50}")
print(f"System fixed to: 1368591213")
print(f"Valid: {validate_iranian_national_id('1368591213')}")
