# راهنمای اجرا - OMR Engine Flask API

## 📋 نیازمندی‌ها

### نصب وابستگی‌ها
```bash
pip install -r requirements.txt
```

### محتویات requirements.txt:
- flask
- numpy
- opencv-python-headless
- easyocr
- torch
- torchvision
- requests (برای تست API)

---

## 🚀 راه‌اندازی سرور

### 1. اجرای سرور Flask
```bash
cd i:/sin-fin/omr-engine
python app.py
```

سرور روی `http://localhost:5000` راه‌اندازی می‌شود.

### 2. تست سلامت سرور
در مرورگر یا با curl:
```bash
curl http://localhost:5000/health
```

خروجی:
```json
{
  "status": "healthy",
  "service": "OMR Engine",
  "timestamp": "2025-12-29T19:00:00"
}
```

---

## 🧪 تست API

### روش 1: استفاده از اسکریپت تست
```bash
python test_api.py
```

### روش 2: با استفاده از curl
```bash
curl -X POST http://localhost:5000/process-omr \
  -F "image=@path/to/your/image.jpg" \
  -F "options_count=5"
```

### روش 3: با استفاده از Postman
1. Method: `POST`
2. URL: `http://localhost:5000/process-omr`
3. Body: `form-data`
   - Key: `image` (Type: File)
   - Key: `options_count` (Type: Text, Value: `5`)

---

## 📡 API Endpoints

### 1. صفحه اصلی
```
GET /
```
اطلاعات کلی API

### 2. بررسی سلامت
```
GET /health
```
چک کردن وضعیت سرور

### 3. پردازش OMR (اصلی)
```
POST /process-omr
Content-Type: multipart/form-data

Parameters:
  - image: file (required) - فایل تصویر JPG/PNG
  - options_count: int (optional, default: 5) - تعداد گزینه‌های هر سوال
```

**پاسخ موفق:**
```json
{
  "status": "success",
  "national_id": "1367937401",
  "answers": {
    "1": 3,
    "2": 4,
    "3": 1,
    ...
  },
  "debug_images": {
    "circles": "/static/debug_circles.jpg",
    "gray": "/static/debug_gray.jpg"
  },
  "processing_time_ms": 2341.5,
  "metadata": {
    "options_count": 5,
    "total_questions": 20,
    "timestamp": "2025-12-29T19:00:00"
  }
}
```

**پاسخ خطا:**
```json
{
  "status": "error",
  "message": "توضیح خطا",
  "processing_time_ms": 150.2
}
```

### 4. دریافت تصاویر دیباگ
```
GET /static/<filename>
```
مثال: `http://localhost:5000/static/debug_circles.jpg`

---

## 🔧 تنظیمات

### تغییر تعداد گزینه‌ها
در درخواست API:
```python
data = {'options_count': 4}  # برای سوالات 4 گزینه‌ای
```

### تغییر پورت سرور
در `app.py`:
```python
app.run(port=8000)  # به جای 5000
```

### فعال‌سازی GPU
در `app.py`:
```python
reader = easyocr.Reader(['fa', 'en'], gpu=True)
```

---

## 🐛 عیب‌یابی

### خطا: "Connection refused"
- مطمئن شوید سرور Flask در حال اجراست
- چک کنید پورت 5000 آزاد باشد

### خطا: "No module named 'easyocr'"
```bash
pip install easyocr
```

### خطا: GPU not available
- نرمال است اگر GPU ندارید
- سرور به صورت خودکار روی CPU اجرا می‌شود

### خطا: "File too large"
- حداکثر حجم: 10MB
- برای تغییر در `app.py`:
```python
app.config['MAX_CONTENT_LENGTH'] = 20 * 1024 * 1024  # 20MB
```

---

## 📊 نکات عملکردی

- **سرعت:** ~2-3 ثانیه برای هر برگه (با CPU)
- **دقت کد ملی:** ~95% با الگوریتم اصلاح خطا
- **دقت پاسخ‌ها:** ~95% برای برگه‌های تمیز، ~85% برای پر کرده‌های نامرتب

---

## 🔒 امنیت (برای Production)

1. تغییر SECRET_KEY
2. غیرفعال کردن DEBUG mode
3. محدودسازی CORS
4. اضافه کردن Rate Limiting
5. استفاده از HTTPS

---

## 📝 مثال کد Python برای استفاده از API

```python
import requests

# آپلود و پردازش تصویر
url = "http://localhost:5000/process-omr"
files = {'image': open('exam_sheet.jpg', 'rb')}
data = {'options_count': 5}

response = requests.post(url, files=files, data=data)
result = response.json()

if result['status'] == 'success':
    print(f"کد ملی: {result['national_id']}")
    for q, ans in result['answers'].items():
        print(f"سوال {q}: گزینه {ans}")
else:
    print(f"خطا: {result['message']}")
```

---

## 📞 پشتیبانی

برای گزارش مشکلات یا پیشنهادات، فایل‌های لاگ را چک کنید:
- Console output سرور Flask
- فایل‌های debug در پوشه `static/`

---

**نسخه:** 2.0  
**تاریخ آخرین بروزرسانی:** 2025-12-29
